Scriptname RF:SettingsScript Extends Quest

Actor PlayerRef

RF:FuelHandlerQuest Property RFQ Mandatory Const Auto
RF:TravelHandlerQuest Property RTQ Mandatory Const Auto
RF:DisasterScript Property RDQ Mandatory Const Auto ; damage quest

Group Settings
    GameplayOption Property _RF_GPO_MODE Mandatory Const Auto
    { This should be the main controller for all logic }
    GameplayOption Property _RF_GPO1 Mandatory Const Auto
    { Travel where 1 is easy mode }
    GameplayOption Property _RF_GPO_Acc Mandatory Const Auto
    { Determines if Cassiopeia logic will run }
    GameplayOption Property _RF_GPO2 Mandatory Const Auto
    { Verbosity where 1 is Verbose }
    GameplayOption Property _RF_GPO3 Mandatory Const Auto
    { Travel where 1 is Hardcore }
    GameplayOption Property _RF_GPO4 Mandatory Const Auto
    { Fuel explosion risk where 1 is hardcore - ship with normal system first }
    GlobalVariable Property ModOnGlobal Const Auto
    { This can indicate mod state for other mods or scripts }
    GlobalVariable Property _RF_Sys_AllowTravel Mandatory Const Auto
    { 1 indicates relaxed mode }
    GlobalVariable Property _RF_Sys_Verbose Mandatory Const Auto
    { 1 indicates verbose }
    GlobalVariable Property _RF_EnableCassiopeiaLogic Mandatory Const Auto
    Message Property DisableMSG Mandatory Const Auto
    { Displayed on transition to disabled }
    Message Property EnableMSG Mandatory Const Auto
    { Displayed on transition to enabled }
    GlobalVariable Property _RF_Sys_TravelLimitHardcore Mandatory Const Auto
    GlobalVariable Property _RF_Sys_FuelDamageHardcore Mandatory Const Auto
EndGroup

bool ModActive = true

;Handler for global & all perks
;aiDisabled must correspond to whichever GPO return value disables the main system
Function CheckSettings(int aiDisabled = 1)
    ;Wait until menu is closed to avoid clogging VM
    Utility.Wait(0.5)
    ;GPO as int, where 0 is enabled (as default)
    int ModToggle = _RF_GPO_MODE.GetValue() as int
    ;Display a message when changing state
    If ModActive && ModToggle == aiDisabled
        DisableMSG.Show()
    ElseIf !ModActive && ModToggle != aiDisabled
        EnableMSG.Show()
    EndIf
    ;Set our bool for the main state to reference elsewhere
    if ModToggle == 0
        ModActive = true
        ModOnGlobal.SetValue(1)
    Else
        ModActive = false
        ModOnGlobal.SetValue(0)
    EndIf
    ;Global so other scripts can reference if needed
    If ModOnGlobal
        ModOnGlobal.SetValue(ModActive as int)
    EndIf
    int Mode1 = _RF_GPO1.GetValue() as int
    int Mode2 = _RF_GPO2.GetValue() as int
    int Mode3 = _RF_GPO3.GetValue() as int
    int Mode4 = _RF_GPO4.GetValue() as int
    int ModeCass = _RF_GPO_Acc.GetValue() as int
    _RF_Sys_AllowTravel.SetValue(Mode1)
    _RF_Sys_Verbose.SetValue(Mode2)
    _RF_Sys_TravelLimitHardcore.SetValue(Mode3)
    _RF_Sys_FuelDamageHardcore.SetValue(Mode4)
    _RF_EnableCassiopeiaLogic.SetValue(ModeCass)
    RFQ.HandleSettings()
    RTQ.TravelSystemEnabled()
EndFunction

Event OnQuestInit()
	StartTimer(5)
    GoToState("Starting")
EndEvent

State Starting
    Event OnTimer(int aiTimerID)
    	RegisterForGameplayOptionChangedEvent()
        GotoState("")
    EndEvent
EndState

Event OnGameplayOptionChanged(GameplayOption[] aChangedOptions)
    IF aChangedOptions.Find(_RF_GPO_MODE) >=0 || aChangedOptions.Find(_RF_GPO_ACC) >=0 || aChangedOptions.Find(_RF_GPO1) >=0 || aChangedOptions.Find(_RF_GPO2) >=0 || aChangedOptions.Find(_RF_GPO3) >=0 
        Debug.Trace("RF Settings detected change")
    	CheckSettings()
    EndIF
EndEvent

;1 indicates Disabled
int Function chkFUEL()
    Return _RF_GPO_MODE.GetValue() as int
EndFunction

;1 indicates No Restrictions
int Function chkTRV()
    Return _RF_GPO1.GetValue() as int
EndFunction

;
int Function chkHC()
    Return _RF_GPO3.GetValue() as int
EndFunction

int Function chkDSTR()
    Return 1 ; _RF_GPO4.GetValue() as int
EndFunction
